/******************************************************************************
 * %Id: ipr_bridge_if.h,v 1.19 2010/02/15 06:26:20 ishikawa Exp $
 *
 * FileName		:vop_bridge_if.h
 *
 * Description	:I/F definition header for bridge (wrapper)
 *
 *
 * Copyright	:Panasonic Corporation.
 *
 *****************************************************************************/
#ifndef	_VOP_BRIDGE_IF_H_
#define	_VOP_BRIDGE_IF_H_

#include <linux/iosc/vop_bridge_data.h>



#define VOP_L_DEVID_MAX_NUM	(VOP_MINOR_NUM - 1)
#define VOP_R_DEVID_MAX_NUM	(VOP_MINOR_NUM - 1)
#define VOP_MAX_FD_NAME		100



/***************/
/* API command */
/***************/
#define VOP_IOC_INIT                            IOSC_DEFINE_RWCMD(L_VOP_MAGIC,   1 , sizeof(vop_init_arg_t))
#define VOP_IOC_TERM                            IOSC_DEFINE_RWCMD(L_VOP_MAGIC,   2 , sizeof(vop_term_arg_t))
#define VOP_IOC_SETREGUPDATEMODE                IOSC_DEFINE_RWCMD(L_VOP_MAGIC,   3 , sizeof(vop_reg_update_mode_arg_t))
#define VOP_IOC_GETREGUPDATEMODE                IOSC_DEFINE_RWCMD(L_VOP_MAGIC,   4 , sizeof(vop_reg_update_mode_arg_t))
#define VOP_IOC_REFRESH                         IOSC_DEFINE_RWCMD(L_VOP_MAGIC,   5 , sizeof(vop_reg_update_mode_arg_t))
#define VOP_IOC_SETDETECTWINDOW                 IOSC_DEFINE_RWCMD(L_VOP_MAGIC,   6 , sizeof(vop_detect_window_arg_t))
#define VOP_IOC_GETDETECTWINDOW                 IOSC_DEFINE_RWCMD(L_VOP_MAGIC,   7 , sizeof(vop_detect_window_arg_t))
#define VOP_IOC_SETADAPTCOMMON                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC,   8 , sizeof(vop_adapt_common_arg_t))
#define VOP_IOC_GETADAPTCOMMON                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC,   9 , sizeof(vop_adapt_common_arg_t))
#define VOP_IOC_SETAREADETECTPARAM              IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  10 , sizeof(vop_area_detect_param_arg_t))
#define VOP_IOC_GETAREADETECTPARAM              IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  11 , sizeof(vop_area_detect_param_arg_t))
#define VOP_IOC_GETADAPTDETECT                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  12 , sizeof(vop_adapt_detect_arg_t))
#define VOP_IOC_GETADAPTDETECTRAW               IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  13 , sizeof(vop_adapt_detect_raw_arg_t))
#define VOP_IOC_GETAREADETECT                   IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  14 , sizeof(vop_area_detect_arg_t))
#define VOP_IOC_SETADAPTBLOCK                   IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  15 , sizeof(vop_adapt_block_arg_t))
#define VOP_IOC_GETADAPTBLOCK                   IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  16 , sizeof(vop_adapt_block_arg_t))
#define VOP_IOC_SETADAPTHST                     IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  17 , sizeof(vop_adapt_hst_arg_t))
#define VOP_IOC_GETADAPTHST                     IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  18 , sizeof(vop_adapt_hst_arg_t))
#define VOP_IOC_SETMANUALHST                    IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  19 , sizeof(vop_manual_hst_arg_t))
#define VOP_IOC_GETMANUALHST                    IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  20 , sizeof(vop_manual_hst_arg_t))
#define VOP_IOC_SETADAPTGAMMA                   IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  21 , sizeof(vop_adapt_gamma_arg_t))
#define VOP_IOC_GETADAPTGAMMA                   IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  22 , sizeof(vop_adapt_gamma_arg_t))
#define VOP_IOC_SETADAPTCRT                     IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  23 , sizeof(vop_adapt_crt_arg_t))
#define VOP_IOC_GETADAPTCRT                     IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  24 , sizeof(vop_adapt_crt_arg_t))
#define VOP_IOC_SETADAPTCOLOR                   IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  25 , sizeof(vop_adapt_color_arg_t))
#define VOP_IOC_GETADAPTCOLOR                   IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  26 , sizeof(vop_adapt_color_arg_t))
#define VOP_IOC_SETADAPTYC                      IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  27 , sizeof(vop_adapt_yc_arg_t))
#define VOP_IOC_GETADAPTYC                      IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  28 , sizeof(vop_adapt_yc_arg_t))
#define VOP_IOC_SETMANUALYC                     IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  29 , sizeof(vop_manual_yc_arg_t))
#define VOP_IOC_GETMANUALYC                     IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  30 , sizeof(vop_manual_yc_arg_t))
#define VOP_IOC_SETADAPTWINDOW                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  31 , sizeof(vop_adapt_window_arg_t))
#define VOP_IOC_GETADAPTWINDOW                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  32 , sizeof(vop_adapt_window_arg_t))
#define VOP_IOC_GETADAPTGAIN                    IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  33 , sizeof(vop_adapt_gain_arg_t))
#define VOP_IOC_SETYBLACK                       IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  34 , sizeof(vop_yblack_arg_t))
#define VOP_IOC_GETYBLACK                       IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  35 , sizeof(vop_yblack_arg_t))
#define VOP_IOC_SETREDGAMMA                     IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  36 , sizeof(vop_red_gamma_arg_t))
#define VOP_IOC_GETREDGAMMA                     IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  37 , sizeof(vop_red_gamma_arg_t))
#define VOP_IOC_SETENHANCEBLOCK                 IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  38 , sizeof(vop_enhance_block_arg_t))
#define VOP_IOC_GETENHANCEBLOCK                 IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  39 , sizeof(vop_enhance_block_arg_t))
#define VOP_IOC_SETENHANCECOMMON                IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  40 , sizeof(vop_enhance_common_arg_t))
#define VOP_IOC_GETENHANCECOMMON                IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  41 , sizeof(vop_enhance_common_arg_t))
#define VOP_IOC_GETEDGEHST                      IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  42 , sizeof(vop_edge_hst_arg_t))
#define VOP_IOC_SETYPKLOW                       IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  43 , sizeof(vop_ypk_low_arg_t))
#define VOP_IOC_GETYPKLOW                       IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  44 , sizeof(vop_ypk_low_arg_t))
#define VOP_IOC_SETYPKHIGH                      IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  45 , sizeof(vop_ypk_high_arg_t))
#define VOP_IOC_GETYPKHIGH                      IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  46 , sizeof(vop_ypk_high_arg_t))
#define VOP_IOC_SETYTI                          IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  47 , sizeof(vop_yti_arg_t))
#define VOP_IOC_GETYTI                          IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  48 , sizeof(vop_yti_arg_t))
#define VOP_IOC_SETVPK                          IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  49 , sizeof(vop_vpk_arg_t))
#define VOP_IOC_GETVPK                          IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  50 , sizeof(vop_vpk_arg_t))
#define VOP_IOC_SETVYTI                         IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  51 , sizeof(vop_vyti_arg_t))
#define VOP_IOC_GETVYTI                         IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  52 , sizeof(vop_vyti_arg_t))
#define VOP_IOC_SETCTI                          IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  53 , sizeof(vop_cti_arg_t))
#define VOP_IOC_GETCTI                          IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  54 , sizeof(vop_cti_arg_t))
#define VOP_IOC_SETDYNAMICYPK                   IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  55 , sizeof(vop_dynamic_ypk_arg_t))
#define VOP_IOC_GETDYNAMICYPK                   IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  56 , sizeof(vop_dynamic_ypk_arg_t))
#define VOP_IOC_SETDYNAMICYTI                   IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  57 , sizeof(vop_dynamic_yti_arg_t))
#define VOP_IOC_GETDYNAMICYTI                   IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  58 , sizeof(vop_dynamic_yti_arg_t))
#define VOP_IOC_SETENHANCEWINDOW                IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  59 , sizeof(vop_enhance_window_arg_t))
#define VOP_IOC_GETENHANCEWINDOW                IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  60 , sizeof(vop_enhance_window_arg_t))
#define VOP_IOC_SETENHANCEREPEATWINDOW          IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  61 , sizeof(vop_enhance_repeat_window_arg_t))
#define VOP_IOC_GETENHANCEREPEATWINDOW          IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  62 , sizeof(vop_enhance_repeat_window_arg_t))

#define VOP_IOC_SETSMOOTH                       IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  65 , sizeof(vop_smooth_arg_t))
#define VOP_IOC_GETSMOOTH                       IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  66 , sizeof(vop_smooth_arg_t))
#define VOP_IOC_SETWCH                          IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  67 , sizeof(vop_wch_arg_t))
#define VOP_IOC_GETWCH                          IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  68 , sizeof(vop_wch_arg_t))

#define VOP_IOC_SETMATRIX                       IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  71 , sizeof(vop_matrix_arg_t))
#define VOP_IOC_GETMATRIX                       IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  72 , sizeof(vop_matrix_arg_t))
#define VOP_IOC_GETMATRIXCOEFFICIENT            IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  73 , sizeof(vop_matrix_coefficient_arg_t))
#define VOP_IOC_SETRGBPEDE                      IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  74 , sizeof(vop_rgb_pede_arg_t))
#define VOP_IOC_GETRGBPEDE                      IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  75 , sizeof(vop_rgb_pede_arg_t))
#define VOP_IOC_SETCOLORMATRIX                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  76 , sizeof(vop_color_matrix_arg_t))
#define VOP_IOC_GETCOLORMATRIX                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  77 , sizeof(vop_color_matrix_arg_t))
#define VOP_IOC_SET6AXIS                        IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  78 , sizeof(vop_6axis_arg_t))
#define VOP_IOC_GET6AXIS                        IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  79 , sizeof(vop_6axis_arg_t))
#define VOP_IOC_SET6AXISVLIMIT                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  80 , sizeof(vop_6axis_v_limit_arg_t))
#define VOP_IOC_GET6AXISVLIMIT                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  81 , sizeof(vop_6axis_v_limit_arg_t))
#define VOP_IOC_SETVADAPT6AXIS                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  82 , sizeof(vop_vadapt_6axis_arg_t))
#define VOP_IOC_GETVADAPT6AXIS                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  83 , sizeof(vop_vadapt_6axis_arg_t))
#define VOP_IOC_SETSELECTIVECOLOR               IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  84 , sizeof(vop_selective_color_arg_t))
#define VOP_IOC_GETSELECTIVECOLOR               IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  85 , sizeof(vop_selective_color_arg_t))
#define VOP_IOC_SETHSVCOLOR                     IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  86 , sizeof(vop_hsv_color_arg_t))
#define VOP_IOC_GETHSVCOLOR                     IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  87 , sizeof(vop_hsv_color_arg_t))
#define VOP_IOC_SETCOLORWINDOW                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  88 , sizeof(vop_color_window_arg_t))
#define VOP_IOC_GETCOLORWINDOW                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  89 , sizeof(vop_color_window_arg_t))
#define VOP_IOC_SETYUVBLOCK                     IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  90 , sizeof(vop_yuv_block_arg_t))
#define VOP_IOC_GETYUVBLOCK                     IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  91 , sizeof(vop_yuv_block_arg_t))

#define VOP_IOC_SETLEVEL                        IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  96 , sizeof(vop_level_arg_t))
#define VOP_IOC_GETLEVEL                        IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  97 , sizeof(vop_level_arg_t))
#define VOP_IOC_SETDC                           IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  98 , sizeof(vop_dc_arg_t))
#define VOP_IOC_GETDC                           IOSC_DEFINE_RWCMD(L_VOP_MAGIC,  99 , sizeof(vop_dc_arg_t))
#define VOP_IOC_SETCOLORTEMP                    IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 100 , sizeof(vop_color_temp_arg_t))
#define VOP_IOC_GETCOLORTEMP                    IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 101 , sizeof(vop_color_temp_arg_t))
#define VOP_IOC_SETLUTGAMMABLOCK                IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 102 , sizeof(vop_lut_gamma_block_arg_t))
#define VOP_IOC_GETLUTGAMMABLOCK                IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 103 , sizeof(vop_lut_gamma_block_arg_t))
#define VOP_IOC_SETLUT                          IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 104 , sizeof(vop_lut_arg_t))
#define VOP_IOC_SETNOISESHAPING                 IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 105 , sizeof(vop_noise_shaping_arg_t))
#define VOP_IOC_GETNOISESHAPING                 IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 106 , sizeof(vop_noise_shaping_arg_t))

#define VOP_IOC_SETRGBMASKPULSE                 IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 109 , sizeof(vop_rgbmask_pulse_arg_t))
#define VOP_IOC_GETRGBMASKPULSE                 IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 110 , sizeof(vop_rgbmask_pulse_arg_t))
#define VOP_IOC_SETBACKLIGHTPWM                 IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 111 , sizeof(vop_backlight_pwm_arg_t))
#define VOP_IOC_GETBACKLIGHTPWM                 IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 112 , sizeof(vop_backlight_pwm_arg_t))
#define VOP_IOC_SETACTIVEWINDOW                 IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 117 , sizeof(vop_active_window_arg_t))
#define VOP_IOC_GETACTIVEWINDOW                 IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 118 , sizeof(vop_active_window_arg_t))
#define VOP_IOC_SETINTRPROC                     IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 119 , sizeof(vop_intrproc_arg_t))
#define VOP_IOC_CLEARINTRPROC                   IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 120 , sizeof(vop_intrproc_arg_t))
#define VOP_IOC_GETPROBE                        IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 123 , sizeof(vop_probe_arg_t))
#define VOP_IOC_SETPROBEONCE                    IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 124 , sizeof(vop_probe_once_arg_t))
#define VOP_IOC_GETPROBEONCE                    IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 125 , sizeof(vop_probe_once_arg_t))

#define VOP_IOC_SETSIGNALFORM                   IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 128 , sizeof(vop_signal_form_arg_t))
#define VOP_IOC_GETSIGNALFORM                   IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 129 , sizeof(vop_signal_form_arg_t))
#define VOP_IOC_SETREVERSESCAN                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 130 , sizeof(vop_reverse_scan_arg_t))
#define VOP_IOC_GETREVERSESCAN                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 131 , sizeof(vop_reverse_scan_arg_t))
#define VOP_IOC_GETDETECTYHST256                IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 132 , sizeof(vop_detect_yhst256_arg_t))
#define VOP_IOC_SETYGAMMA256                    IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 133 , sizeof(vop_ygamma256_arg_t))
#define VOP_IOC_GETYGAMMA256                    IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 134 , sizeof(vop_ygamma256_arg_t))
#define VOP_IOC_SETYWHITE                       IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 135 , sizeof(vop_ywhite_arg_t))
#define VOP_IOC_GETYWHITE                       IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 136 , sizeof(vop_ywhite_arg_t))
#define VOP_IOC_SETSELECTIVEGRADATION           IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 137 , sizeof(vop_selective_gradation_arg_t))
#define VOP_IOC_GETSELECTIVEGRADATION           IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 138 , sizeof(vop_selective_gradation_arg_t))
#define VOP_IOC_SETSELECTIVEENHANCE             IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 139 , sizeof(vop_selective_enhance_arg_t))
#define VOP_IOC_GETSELECTIVEENHANCE             IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 140 , sizeof(vop_selective_enhance_arg_t))
#define VOP_IOC_SETDCNR                         IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 141 , sizeof(vop_dcnr_arg_t))
#define VOP_IOC_GETDCNR                         IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 142 , sizeof(vop_dcnr_arg_t))
#define VOP_IOC_SETLDPANELINFO                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 143 , sizeof(vop_ld_panel_info_arg_t))
#define VOP_IOC_GETLDPANELINFO                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 144 , sizeof(vop_ld_panel_info_arg_t))
#define VOP_IOC_SETLDSPIFORMAT                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 145 , sizeof(vop_ld_spi_format_arg_t))
#define VOP_IOC_GETLDSPIFORMAT                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 146 , sizeof(vop_ld_spi_format_arg_t))
#define VOP_IOC_SETLDCONTROL                    IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 147 , sizeof(vop_ld_control_arg_t))
#define VOP_IOC_GETLDCONTROL                    IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 148 , sizeof(vop_ld_control_arg_t))
#define VOP_IOC_SETLDRGBEFFECT                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 149 , sizeof(vop_ld_rgb_effect_arg_t))
#define VOP_IOC_GETLDRGBEFFECT                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 150 , sizeof(vop_ld_rgb_effect_arg_t))
#define VOP_IOC_SETDIAGONALYPK                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 151 , sizeof(vop_diagonal_ypk_arg_t))
#define VOP_IOC_GETDIAGONALYPK                  IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 152 , sizeof(vop_diagonal_ypk_arg_t))
#define VOP_IOC_GETSATHST                       IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 153 , sizeof(vop_sat_hst_arg_t))
#define VOP_IOC_SET2BINHISTOPARAM               IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 154 , sizeof(vop_2bin_histo_param_arg_t))
#define VOP_IOC_GET2BINHISTOPARAM               IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 155 , sizeof(vop_2bin_histo_param_arg_t))
#define VOP_IOC_GET2BINHISTO                    IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 156 , sizeof(vop_2bin_histo_arg_t))
#define VOP_IOC_SETSRHSTPARAM                   IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 157 , sizeof(vop_srhst_param_arg_t))
#define VOP_IOC_GETSRHSTPARAM                   IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 158 , sizeof(vop_srhst_param_arg_t))
#define VOP_IOC_GETEDGEVHST                     IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 159 , sizeof(vop_edge_hst_arg_t))
#define VOP_IOC_SETSMOOTHMODE                   IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 160 , sizeof(vop_smooth_mode_arg_t))
#define VOP_IOC_GETSMOOTHMODE                   IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 161 , sizeof(vop_smooth_mode_arg_t))
#define VOP_IOC_SETODBLOCK                      IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 162 , sizeof(vop_od_block_arg_t))
#define VOP_IOC_GETODBLOCK                      IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 163 , sizeof(vop_od_block_arg_t))
#define VOP_IOC_GETFREQHST                      IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 164 , sizeof(vop_freq_hst_arg_t))
#define VOP_IOC_SETFREQHSTPARAM                 IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 165 , sizeof(vop_freqhst_param_arg_t))
#define VOP_IOC_GETFREQHSTPARAM                 IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 166 , sizeof(vop_freqhst_param_arg_t))
#define VOP_IOC_SET6AXISRANGE                   IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 167 , sizeof(vop_6axis_range_arg_t))
#define VOP_IOC_GET6AXISRANGE                   IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 168 , sizeof(vop_6axis_range_arg_t))
#define VOP_IOC_SETFRCDITHER                    IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 169 , sizeof(vop_frc_dither_arg_t))
#define VOP_IOC_GETFRCDITHER                    IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 170 , sizeof(vop_frc_dither_arg_t))
#define VOP_IOC_SETFRCDITHERLUT                 IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 171 , sizeof(vop_frc_dither_lut_arg_t))
#define VOP_IOC_GETFRCDITHERLUT                 IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 172 , sizeof(vop_frc_dither_lut_arg_t))
#define VOP_IOC_SETRGBMASKCOLOR                 IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 173 , sizeof(vop_rgbmask_color_arg_t))
#define VOP_IOC_GETRGBMASKCOLOR                 IOSC_DEFINE_RWCMD(L_VOP_MAGIC, 174 , sizeof(vop_rgbmask_color_arg_t))

/************/
/* CALLBACK */
/************/
#define VOP_IOC_INTRCALLBACK                    IOSC_DEFINE_RWCMD(L_VOP_MAGIC,   1 , sizeof(vop_intrproc_arg_t))



#endif	/* #ifndef	_VOP_BRIDGE_IF_H_ */
